unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RDX, StdCtrls, ExtCtrls, mmsystem;

type
  TForm1 = class(TForm)
    RenderDX1: TRenderDX;
    Memo1: TMemo;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    original_pal : hPalette;
    procedure AppIdle(Sender: TObject; var Done: Boolean);
  public
    // flags for direction of movement;
    Rotating : integer;
    Moving   : integer;
    Shearing : integer;

    tickcount : integer; // this is the frame tick count.
    tickerr   : integer; // we accumulate errors here, so that the
                          // movement is smooth.
    StartTime,EndTime : integer; // For Timing


    // Amounts of movement
    Shear    : integer;   // looking up and down
    Velocity : integer;   // moving forward/backward
    Spin     : integer;   // angles turning
    MaxVelocity  : integer;

    function GetPalette : hPalette; override;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function TForm1.GetPalette : hPalette;
begin
   result :=  hPalette(renderdx1.palette);
end;

procedure TForm1.AppIdle(Sender: TObject; var Done: Boolean);
var ctr : integer;
    remain : integer;
    erraccum : integer;
begin
    StartTime := EndTime;
    EndTime   := TimeGetTime; // count in milliseconds
    ctr       := EndTime - StartTime; // ctr = # of milliseconds since last render
    TickCount := ctr shr 4;           // div 16
    remain    := ctr - (ctr  shl 4);  // mod 16
    tickerr   := Tickerr + remain;    // accumulate error
    if tickerr >= 16 then begin       // pull 'whole ticks' off err
       erraccum  := tickerr shl 4;
       tickcount := tickcount + erraccum;
       tickerr   := tickerr - (erraccum shr 4);
    end;

    Done := False;
    if moving <> 0 then begin
       // speed up
       inc(velocity,moving*tickcount);
       if velocity >  maxvelocity then velocity :=  maxvelocity;
       if velocity < -maxvelocity then velocity := -maxvelocity;
    end else begin
       // slow down
       if velocity > 0 then begin
          if velocity >= tickcount then dec(velocity,tickcount) else velocity := 0;
       end;
       if velocity < 0 then begin
          if velocity <= (-tickcount) then inc(velocity,tickcount) else velocity := 0;
       end;
    end;

    if rotating <> 0 then begin
       // speed up rotation
       inc(spin,rotating*tickcount);
       if spin >  16 then spin :=  16;
       if spin < -16 then spin := -16;
    end else begin
       // slow down rotation
       if spin >  0 then begin
          if spin >= tickcount then dec(spin,tickcount) else spin := 0;
       end;
       if spin <  0 then begin
         if spin <= (-tickcount)then inc(spin,tickcount) else spin := 0;
       end;
    end;

    if shearing <> 0 then begin
       // Look farther up and down
       inc(shear,shearing*tickcount*4);
       if shear >  200 then shear :=  200;
       if shear < -200 then shear := -200;
    end else begin
       // Move view back toward center.
       if shear >  0 then
          if shear >= (tickcount *4) then dec(shear,tickcount*4) else shear := 0;
       if shear <  0 then
          if shear <= (tickcount *-4) then inc(shear,tickcount*4) else shear := 0;
    end;

    // move viewpoint, spin, and shear the view.
    if velocity <> 0 then begin
       RenderDX1.MoveActor(0,velocity);
    end;
    if spin <> 0 then begin
       RenderDX1.SpinActor(0,Spin);
    end;
    RenderDX1.Shear := shear;
    RenderDX1.CheckActor(0);
    RenderDX1.Render(0,0);
    Application.ProcessMessages;
    RenderDX1.Repaint;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     case Key of
         VK_UP:    moving   :=  1;
         VK_DOWN:  moving   := -1;
         VK_LEFT:  rotating := -1;
         VK_RIGHT: rotating :=  1;
         VK_PRIOR: shearing := -1;
         VK_NEXT:  shearing :=  1;
     end;
end;

procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     case Key of
         VK_UP:    moving   :=  0;
         VK_DOWN:  moving   :=  0;
         VK_LEFT:  rotating :=  0;
         VK_RIGHT: rotating :=  0;
         VK_PRIOR: shearing :=  0;
         VK_NEXT:  shearing :=  0;
     end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var dirname : string;
begin
    Application.OnIdle := AppIdle;
    dirname := ExtractFilePath(application.exename);
    dirname := dirname+'..\demogrx\';
    MaxVelocity := 24;
    RenderDX1.FlatSet    := dirname+'default.flt';   // or whatever you saved the flatset as.
    RenderDX1.BitmapSet  := dirname+'default.bst';   // bitmap set, whatever you saved it as.
    RenderDX1.TextureSet := dirname+'default.tdf';   // texture definitions
    RenderDX1.ActorDefs  := dirname+'default.typ';   // Actor Type definitions
    RenderDX1.Level      := dirname+'demo.4dx'; // the actual map level
    EndTime := TimeGetTime;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    Application.OnIdle := nil;
end;

end.
